package io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1


/** ServiceReference holds a reference to Service.legacy.k8s.io */
final case class ServiceReference(
  name : String,
  namespace : String,
  path : Option[String] = None,
  port : Option[Int] = None
) {

  /** Returns a new data with name set to new value */
  def withName(value: String) : ServiceReference = copy(name = value)
  /** transforms name to result of function */
  def mapName(f: String => String) : ServiceReference = copy(name = f(name))

  /** Returns a new data with namespace set to new value */
  def withNamespace(value: String) : ServiceReference = copy(namespace = value)
  /** transforms namespace to result of function */
  def mapNamespace(f: String => String) : ServiceReference = copy(namespace = f(namespace))

  /** Returns a new data with path set to new value */
  def withPath(value: String) : ServiceReference = copy(path = Some(value))
  /** if path has a value, transforms to the result of function*/
  def mapPath(f: String => String) : ServiceReference = copy(path = path.map(f))

  /** Returns a new data with port set to new value */
  def withPort(value: Int) : ServiceReference = copy(port = Some(value))
  /** if port has a value, transforms to the result of function*/
  def mapPort(f: Int => Int) : ServiceReference = copy(port = port.map(f))
}

