package io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1


/** ExternalDocumentation allows referencing an external resource for extended documentation. */
final case class ExternalDocumentation(
  description : Option[String] = None,
  url : Option[String] = None
) {

  /** Returns a new data with description set to new value */
  def withDescription(value: String) : ExternalDocumentation = copy(description = Some(value))
  /** if description has a value, transforms to the result of function*/
  def mapDescription(f: String => String) : ExternalDocumentation = copy(description = description.map(f))

  /** Returns a new data with url set to new value */
  def withUrl(value: String) : ExternalDocumentation = copy(url = Some(value))
  /** if url has a value, transforms to the result of function*/
  def mapUrl(f: String => String) : ExternalDocumentation = copy(url = url.map(f))
}

