package io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1


/** CustomResourceDefinitionCondition contains details for the current condition of this pod. */
final case class CustomResourceDefinitionCondition(
  status : String,
  `type` : String,
  reason : Option[String] = None,
  lastTransitionTime : Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None,
  message : Option[String] = None
) {

  /** Returns a new data with status set to new value */
  def withStatus(value: String) : CustomResourceDefinitionCondition = copy(status = value)
  /** transforms status to result of function */
  def mapStatus(f: String => String) : CustomResourceDefinitionCondition = copy(status = f(status))

  /** Returns a new data with `type` set to new value */
  def withType(value: String) : CustomResourceDefinitionCondition = copy(`type` = value)
  /** transforms `type` to result of function */
  def mapType(f: String => String) : CustomResourceDefinitionCondition = copy(`type` = f(`type`))

  /** Returns a new data with reason set to new value */
  def withReason(value: String) : CustomResourceDefinitionCondition = copy(reason = Some(value))
  /** if reason has a value, transforms to the result of function*/
  def mapReason(f: String => String) : CustomResourceDefinitionCondition = copy(reason = reason.map(f))

  /** Returns a new data with lastTransitionTime set to new value */
  def withLastTransitionTime(value: io.k8s.apimachinery.pkg.apis.meta.v1.Time) : CustomResourceDefinitionCondition = copy(lastTransitionTime = Some(value))
  /** if lastTransitionTime has a value, transforms to the result of function*/
  def mapLastTransitionTime(f: io.k8s.apimachinery.pkg.apis.meta.v1.Time => io.k8s.apimachinery.pkg.apis.meta.v1.Time) : CustomResourceDefinitionCondition = copy(lastTransitionTime = lastTransitionTime.map(f))

  /** Returns a new data with message set to new value */
  def withMessage(value: String) : CustomResourceDefinitionCondition = copy(message = Some(value))
  /** if message has a value, transforms to the result of function*/
  def mapMessage(f: String => String) : CustomResourceDefinitionCondition = copy(message = message.map(f))
}

