package io.k8s.api.storage.v1


/** VolumeAttachmentSource represents a volume that should be attached. Right now only PersistenVolumes can be attached via external attacher, in future we may allow also inline volumes in pods. Exactly one member can be set. */
final case class VolumeAttachmentSource(
  inlineVolumeSpec : Option[io.k8s.api.core.v1.PersistentVolumeSpec] = None,
  persistentVolumeName : Option[String] = None
) {

  /** Returns a new data with inlineVolumeSpec set to new value */
  def withInlineVolumeSpec(value: io.k8s.api.core.v1.PersistentVolumeSpec) : VolumeAttachmentSource = copy(inlineVolumeSpec = Some(value))
  /** if inlineVolumeSpec has a value, transforms to the result of function*/
  def mapInlineVolumeSpec(f: io.k8s.api.core.v1.PersistentVolumeSpec => io.k8s.api.core.v1.PersistentVolumeSpec) : VolumeAttachmentSource = copy(inlineVolumeSpec = inlineVolumeSpec.map(f))

  /** Returns a new data with persistentVolumeName set to new value */
  def withPersistentVolumeName(value: String) : VolumeAttachmentSource = copy(persistentVolumeName = Some(value))
  /** if persistentVolumeName has a value, transforms to the result of function*/
  def mapPersistentVolumeName(f: String => String) : VolumeAttachmentSource = copy(persistentVolumeName = persistentVolumeName.map(f))
}

