package io.k8s.api.rbac.v1

import dev.hnaderi.k8s._

/** Role is a namespaced, logical grouping of PolicyRules that can be referenced as a unit by a RoleBinding. */
final case class Role(
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None,
  rules : Option[Seq[io.k8s.api.rbac.v1.PolicyRule]] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("rbac.authorization.k8s.io", "Role", "v1")


  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : Role = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : Role = copy(metadata = metadata.map(f))

  /** Returns a new data with rules set to new value */
  def withRules(value: Seq[io.k8s.api.rbac.v1.PolicyRule]) : Role = copy(rules = Some(value))
  /** Appends new values to rules */
  def addRules(newValues: io.k8s.api.rbac.v1.PolicyRule*) : Role = copy(rules = Some(rules.fold(newValues)(_ ++ newValues)))
  /** if rules has a value, transforms to the result of function*/
  def mapRules(f: Seq[io.k8s.api.rbac.v1.PolicyRule] => Seq[io.k8s.api.rbac.v1.PolicyRule]) : Role = copy(rules = rules.map(f))
}

