package io.k8s.api.policy.v1

import dev.hnaderi.k8s._

/** Eviction evicts a pod from its node subject to certain policies and safety constraints. This is a subresource of Pod.  A request to cause such an eviction is created by POSTing to .../pods/<pod name>/evictions. */
final case class Eviction(
  deleteOptions : Option[io.k8s.apimachinery.pkg.apis.meta.v1.DeleteOptions] = None,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("policy", "Eviction", "v1")


  /** Returns a new data with deleteOptions set to new value */
  def withDeleteOptions(value: io.k8s.apimachinery.pkg.apis.meta.v1.DeleteOptions) : Eviction = copy(deleteOptions = Some(value))
  /** if deleteOptions has a value, transforms to the result of function*/
  def mapDeleteOptions(f: io.k8s.apimachinery.pkg.apis.meta.v1.DeleteOptions => io.k8s.apimachinery.pkg.apis.meta.v1.DeleteOptions) : Eviction = copy(deleteOptions = deleteOptions.map(f))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : Eviction = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : Eviction = copy(metadata = metadata.map(f))
}

