package io.k8s.api.networking.v1


/** ServiceBackendPort is the service port being referenced. */
final case class ServiceBackendPort(
  name : Option[String] = None,
  number : Option[Int] = None
) {

  /** Returns a new data with name set to new value */
  def withName(value: String) : ServiceBackendPort = copy(name = Some(value))
  /** if name has a value, transforms to the result of function*/
  def mapName(f: String => String) : ServiceBackendPort = copy(name = name.map(f))

  /** Returns a new data with number set to new value */
  def withNumber(value: Int) : ServiceBackendPort = copy(number = Some(value))
  /** if number has a value, transforms to the result of function*/
  def mapNumber(f: Int => Int) : ServiceBackendPort = copy(number = number.map(f))
}

