package io.k8s.api.networking.v1


/** NetworkPolicyStatus describe the current state of the NetworkPolicy. */
final case class NetworkPolicyStatus(
  conditions : Option[Seq[io.k8s.apimachinery.pkg.apis.meta.v1.Condition]] = None
) {

  /** Returns a new data with conditions set to new value */
  def withConditions(value: Seq[io.k8s.apimachinery.pkg.apis.meta.v1.Condition]) : NetworkPolicyStatus = copy(conditions = Some(value))
  /** Appends new values to conditions */
  def addConditions(newValues: io.k8s.apimachinery.pkg.apis.meta.v1.Condition*) : NetworkPolicyStatus = copy(conditions = Some(conditions.fold(newValues)(_ ++ newValues)))
  /** if conditions has a value, transforms to the result of function*/
  def mapConditions(f: Seq[io.k8s.apimachinery.pkg.apis.meta.v1.Condition] => Seq[io.k8s.apimachinery.pkg.apis.meta.v1.Condition]) : NetworkPolicyStatus = copy(conditions = conditions.map(f))
}

