package io.k8s.api.networking.v1


/** NetworkPolicyPeer describes a peer to allow traffic to/from. Only certain combinations of fields are allowed */
final case class NetworkPolicyPeer(
  ipBlock : Option[io.k8s.api.networking.v1.IPBlock] = None,
  namespaceSelector : Option[io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector] = None,
  podSelector : Option[io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector] = None
) {

  /** Returns a new data with ipBlock set to new value */
  def withIpBlock(value: io.k8s.api.networking.v1.IPBlock) : NetworkPolicyPeer = copy(ipBlock = Some(value))
  /** if ipBlock has a value, transforms to the result of function*/
  def mapIpBlock(f: io.k8s.api.networking.v1.IPBlock => io.k8s.api.networking.v1.IPBlock) : NetworkPolicyPeer = copy(ipBlock = ipBlock.map(f))

  /** Returns a new data with namespaceSelector set to new value */
  def withNamespaceSelector(value: io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector) : NetworkPolicyPeer = copy(namespaceSelector = Some(value))
  /** if namespaceSelector has a value, transforms to the result of function*/
  def mapNamespaceSelector(f: io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector => io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector) : NetworkPolicyPeer = copy(namespaceSelector = namespaceSelector.map(f))

  /** Returns a new data with podSelector set to new value */
  def withPodSelector(value: io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector) : NetworkPolicyPeer = copy(podSelector = Some(value))
  /** if podSelector has a value, transforms to the result of function*/
  def mapPodSelector(f: io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector => io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector) : NetworkPolicyPeer = copy(podSelector = podSelector.map(f))
}

