package io.k8s.api.networking.v1

import dev.hnaderi.k8s._

/** NetworkPolicy describes what network traffic is allowed for a set of Pods */
final case class NetworkPolicy(
  status : Option[io.k8s.api.networking.v1.NetworkPolicyStatus] = None,
  spec : Option[io.k8s.api.networking.v1.NetworkPolicySpec] = None,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("networking.k8s.io", "NetworkPolicy", "v1")


  /** Returns a new data with status set to new value */
  def withStatus(value: io.k8s.api.networking.v1.NetworkPolicyStatus) : NetworkPolicy = copy(status = Some(value))
  /** if status has a value, transforms to the result of function*/
  def mapStatus(f: io.k8s.api.networking.v1.NetworkPolicyStatus => io.k8s.api.networking.v1.NetworkPolicyStatus) : NetworkPolicy = copy(status = status.map(f))

  /** Returns a new data with spec set to new value */
  def withSpec(value: io.k8s.api.networking.v1.NetworkPolicySpec) : NetworkPolicy = copy(spec = Some(value))
  /** if spec has a value, transforms to the result of function*/
  def mapSpec(f: io.k8s.api.networking.v1.NetworkPolicySpec => io.k8s.api.networking.v1.NetworkPolicySpec) : NetworkPolicy = copy(spec = spec.map(f))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : NetworkPolicy = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : NetworkPolicy = copy(metadata = metadata.map(f))
}

