package io.k8s.api.networking.v1


/** IngressStatus describe the current state of the Ingress. */
final case class IngressStatus(
  loadBalancer : Option[io.k8s.api.core.v1.LoadBalancerStatus] = None
) {

  /** Returns a new data with loadBalancer set to new value */
  def withLoadBalancer(value: io.k8s.api.core.v1.LoadBalancerStatus) : IngressStatus = copy(loadBalancer = Some(value))
  /** if loadBalancer has a value, transforms to the result of function*/
  def mapLoadBalancer(f: io.k8s.api.core.v1.LoadBalancerStatus => io.k8s.api.core.v1.LoadBalancerStatus) : IngressStatus = copy(loadBalancer = loadBalancer.map(f))
}

