package io.k8s.api.events.v1


/** EventSeries contain information on series of events, i.e. thing that was/is happening continuously for some time. How often to update the EventSeries is up to the event reporters. The default event reporter in "k8s.io/client-go/tools/events/event_broadcaster.go" shows how this struct is updated on heartbeats and can guide customized reporter implementations. */
final case class EventSeries(
  count : Int,
  lastObservedTime : io.k8s.apimachinery.pkg.apis.meta.v1.MicroTime
) {

  /** Returns a new data with count set to new value */
  def withCount(value: Int) : EventSeries = copy(count = value)
  /** transforms count to result of function */
  def mapCount(f: Int => Int) : EventSeries = copy(count = f(count))

  /** Returns a new data with lastObservedTime set to new value */
  def withLastObservedTime(value: io.k8s.apimachinery.pkg.apis.meta.v1.MicroTime) : EventSeries = copy(lastObservedTime = value)
  /** transforms lastObservedTime to result of function */
  def mapLastObservedTime(f: io.k8s.apimachinery.pkg.apis.meta.v1.MicroTime => io.k8s.apimachinery.pkg.apis.meta.v1.MicroTime) : EventSeries = copy(lastObservedTime = f(lastObservedTime))
}

