package io.k8s.api.core.v1


/** Represents a vSphere volume resource. */
final case class VsphereVirtualDiskVolumeSource(
  volumePath : String,
  fsType : Option[String] = None,
  storagePolicyID : Option[String] = None,
  storagePolicyName : Option[String] = None
) {

  /** Returns a new data with volumePath set to new value */
  def withVolumePath(value: String) : VsphereVirtualDiskVolumeSource = copy(volumePath = value)
  /** transforms volumePath to result of function */
  def mapVolumePath(f: String => String) : VsphereVirtualDiskVolumeSource = copy(volumePath = f(volumePath))

  /** Returns a new data with fsType set to new value */
  def withFsType(value: String) : VsphereVirtualDiskVolumeSource = copy(fsType = Some(value))
  /** if fsType has a value, transforms to the result of function*/
  def mapFsType(f: String => String) : VsphereVirtualDiskVolumeSource = copy(fsType = fsType.map(f))

  /** Returns a new data with storagePolicyID set to new value */
  def withStoragePolicyID(value: String) : VsphereVirtualDiskVolumeSource = copy(storagePolicyID = Some(value))
  /** if storagePolicyID has a value, transforms to the result of function*/
  def mapStoragePolicyID(f: String => String) : VsphereVirtualDiskVolumeSource = copy(storagePolicyID = storagePolicyID.map(f))

  /** Returns a new data with storagePolicyName set to new value */
  def withStoragePolicyName(value: String) : VsphereVirtualDiskVolumeSource = copy(storagePolicyName = Some(value))
  /** if storagePolicyName has a value, transforms to the result of function*/
  def mapStoragePolicyName(f: String => String) : VsphereVirtualDiskVolumeSource = copy(storagePolicyName = storagePolicyName.map(f))
}

