package io.k8s.api.core.v1


/** volumeDevice describes a mapping of a raw block device within a container. */
final case class VolumeDevice(
  devicePath : String,
  name : String
) {

  /** Returns a new data with devicePath set to new value */
  def withDevicePath(value: String) : VolumeDevice = copy(devicePath = value)
  /** transforms devicePath to result of function */
  def mapDevicePath(f: String => String) : VolumeDevice = copy(devicePath = f(devicePath))

  /** Returns a new data with name set to new value */
  def withName(value: String) : VolumeDevice = copy(name = value)
  /** transforms name to result of function */
  def mapName(f: String => String) : VolumeDevice = copy(name = f(name))
}

