package io.k8s.api.core.v1


/** TypedLocalObjectReference contains enough information to let you locate the typed referenced object inside the same namespace. */
final case class TypedLocalObjectReference(
  name : String,
  apiGroup : Option[String] = None
) {

  /** Returns a new data with name set to new value */
  def withName(value: String) : TypedLocalObjectReference = copy(name = value)
  /** transforms name to result of function */
  def mapName(f: String => String) : TypedLocalObjectReference = copy(name = f(name))

  /** Returns a new data with apiGroup set to new value */
  def withApiGroup(value: String) : TypedLocalObjectReference = copy(apiGroup = Some(value))
  /** if apiGroup has a value, transforms to the result of function*/
  def mapApiGroup(f: String => String) : TypedLocalObjectReference = copy(apiGroup = apiGroup.map(f))
}

