package io.k8s.api.core.v1


/** The node this Taint is attached to has the "effect" on any pod that does not tolerate the Taint. */
final case class Taint(
  effect : String,
  key : String,
  timeAdded : Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None,
  value : Option[String] = None
) {

  /** Returns a new data with effect set to new value */
  def withEffect(value: String) : Taint = copy(effect = value)
  /** transforms effect to result of function */
  def mapEffect(f: String => String) : Taint = copy(effect = f(effect))

  /** Returns a new data with key set to new value */
  def withKey(value: String) : Taint = copy(key = value)
  /** transforms key to result of function */
  def mapKey(f: String => String) : Taint = copy(key = f(key))

  /** Returns a new data with timeAdded set to new value */
  def withTimeAdded(value: io.k8s.apimachinery.pkg.apis.meta.v1.Time) : Taint = copy(timeAdded = Some(value))
  /** if timeAdded has a value, transforms to the result of function*/
  def mapTimeAdded(f: io.k8s.apimachinery.pkg.apis.meta.v1.Time => io.k8s.apimachinery.pkg.apis.meta.v1.Time) : Taint = copy(timeAdded = timeAdded.map(f))

  /** Returns a new data with value set to new value */
  def withValue(value: String) : Taint = copy(value = Some(value))
  /** if value has a value, transforms to the result of function*/
  def mapValue(f: String => String) : Taint = copy(value = value.map(f))
}

