package io.k8s.api.core.v1

import dev.hnaderi.k8s._

/** ServiceAccountList is a list of ServiceAccount objects */
final case class ServiceAccountList(
  items : Seq[io.k8s.api.core.v1.ServiceAccount],
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("", "ServiceAccountList", "v1")


  /** Returns a new data with items set to new value */
  def withItems(value: Seq[io.k8s.api.core.v1.ServiceAccount]) : ServiceAccountList = copy(items = value)
  /** Appends new values to items */
  def addItems(newValues: io.k8s.api.core.v1.ServiceAccount*) : ServiceAccountList = copy(items = items ++ newValues)
  /** transforms items to result of function */
  def mapItems(f: Seq[io.k8s.api.core.v1.ServiceAccount] => Seq[io.k8s.api.core.v1.ServiceAccount]) : ServiceAccountList = copy(items = f(items))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : ServiceAccountList = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : ServiceAccountList = copy(metadata = metadata.map(f))
}

