package io.k8s.api.core.v1

import dev.hnaderi.k8s._

/** ServiceAccount binds together: * a name, understood by users, and perhaps by peripheral systems, for an identity * a principal that can be authenticated and authorized * a set of secrets */
final case class ServiceAccount(
  imagePullSecrets : Option[Seq[io.k8s.api.core.v1.LocalObjectReference]] = None,
  secrets : Option[Seq[io.k8s.api.core.v1.ObjectReference]] = None,
  automountServiceAccountToken : Option[Boolean] = None,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("", "ServiceAccount", "v1")


  /** Returns a new data with imagePullSecrets set to new value */
  def withImagePullSecrets(value: Seq[io.k8s.api.core.v1.LocalObjectReference]) : ServiceAccount = copy(imagePullSecrets = Some(value))
  /** Appends new values to imagePullSecrets */
  def addImagePullSecrets(newValues: io.k8s.api.core.v1.LocalObjectReference*) : ServiceAccount = copy(imagePullSecrets = Some(imagePullSecrets.fold(newValues)(_ ++ newValues)))
  /** if imagePullSecrets has a value, transforms to the result of function*/
  def mapImagePullSecrets(f: Seq[io.k8s.api.core.v1.LocalObjectReference] => Seq[io.k8s.api.core.v1.LocalObjectReference]) : ServiceAccount = copy(imagePullSecrets = imagePullSecrets.map(f))

  /** Returns a new data with secrets set to new value */
  def withSecrets(value: Seq[io.k8s.api.core.v1.ObjectReference]) : ServiceAccount = copy(secrets = Some(value))
  /** Appends new values to secrets */
  def addSecrets(newValues: io.k8s.api.core.v1.ObjectReference*) : ServiceAccount = copy(secrets = Some(secrets.fold(newValues)(_ ++ newValues)))
  /** if secrets has a value, transforms to the result of function*/
  def mapSecrets(f: Seq[io.k8s.api.core.v1.ObjectReference] => Seq[io.k8s.api.core.v1.ObjectReference]) : ServiceAccount = copy(secrets = secrets.map(f))

  /** Returns a new data with automountServiceAccountToken set to new value */
  def withAutomountServiceAccountToken(value: Boolean) : ServiceAccount = copy(automountServiceAccountToken = Some(value))
  /** if automountServiceAccountToken has a value, transforms to the result of function*/
  def mapAutomountServiceAccountToken(f: Boolean => Boolean) : ServiceAccount = copy(automountServiceAccountToken = automountServiceAccountToken.map(f))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : ServiceAccount = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : ServiceAccount = copy(metadata = metadata.map(f))
}

