package io.k8s.api.core.v1

import dev.hnaderi.k8s._

/** ResourceQuotaList is a list of ResourceQuota items. */
final case class ResourceQuotaList(
  items : Seq[io.k8s.api.core.v1.ResourceQuota],
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("", "ResourceQuotaList", "v1")


  /** Returns a new data with items set to new value */
  def withItems(value: Seq[io.k8s.api.core.v1.ResourceQuota]) : ResourceQuotaList = copy(items = value)
  /** Appends new values to items */
  def addItems(newValues: io.k8s.api.core.v1.ResourceQuota*) : ResourceQuotaList = copy(items = items ++ newValues)
  /** transforms items to result of function */
  def mapItems(f: Seq[io.k8s.api.core.v1.ResourceQuota] => Seq[io.k8s.api.core.v1.ResourceQuota]) : ResourceQuotaList = copy(items = f(items))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : ResourceQuotaList = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : ResourceQuotaList = copy(metadata = metadata.map(f))
}

