package io.k8s.api.core.v1

import dev.hnaderi.k8s._

/** PodTemplate describes a template for creating copies of a predefined pod. */
final case class PodTemplate(
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None,
  template : Option[io.k8s.api.core.v1.PodTemplateSpec] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("", "PodTemplate", "v1")


  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : PodTemplate = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : PodTemplate = copy(metadata = metadata.map(f))

  /** Returns a new data with template set to new value */
  def withTemplate(value: io.k8s.api.core.v1.PodTemplateSpec) : PodTemplate = copy(template = Some(value))
  /** if template has a value, transforms to the result of function*/
  def mapTemplate(f: io.k8s.api.core.v1.PodTemplateSpec => io.k8s.api.core.v1.PodTemplateSpec) : PodTemplate = copy(template = template.map(f))
}

