package io.k8s.api.core.v1


/** PodOS defines the OS parameters of a pod. */
final case class PodOS(
  name : String
) {

  /** Returns a new data with name set to new value */
  def withName(value: String) : PodOS = copy(name = value)
  /** transforms name to result of function */
  def mapName(f: String => String) : PodOS = copy(name = f(name))
}

