package io.k8s.api.core.v1


/** Represents a host path mapped into a pod. Host path volumes do not support ownership management or SELinux relabeling. */
final case class HostPathVolumeSource(
  path : String,
  `type` : Option[String] = None
) {

  /** Returns a new data with path set to new value */
  def withPath(value: String) : HostPathVolumeSource = copy(path = value)
  /** transforms path to result of function */
  def mapPath(f: String => String) : HostPathVolumeSource = copy(path = f(path))

  /** Returns a new data with `type` set to new value */
  def withType(value: String) : HostPathVolumeSource = copy(`type` = Some(value))
  /** if `type` has a value, transforms to the result of function*/
  def mapType(f: String => String) : HostPathVolumeSource = copy(`type` = `type`.map(f))
}

