package io.k8s.api.core.v1


/** HTTPHeader describes a custom header to be used in HTTP probes */
final case class HTTPHeader(
  name : String,
  value : String
) {

  /** Returns a new data with name set to new value */
  def withName(value: String) : HTTPHeader = copy(name = value)
  /** transforms name to result of function */
  def mapName(f: String => String) : HTTPHeader = copy(name = f(name))

  /** Returns a new data with value set to new value */
  def withValue(value: String) : HTTPHeader = copy(value = value)
  /** transforms value to result of function */
  def mapValue(f: String => String) : HTTPHeader = copy(value = f(value))
}

