package io.k8s.api.core.v1


/** Represents a Persistent Disk resource in Google Compute Engine.

A GCE PD must exist before mounting to a container. The disk must also be in the same GCE project and zone as the kubelet. A GCE PD can only be mounted as read/write once or read-only many times. GCE PDs support ownership management and SELinux relabeling. */
final case class GCEPersistentDiskVolumeSource(
  pdName : String,
  fsType : Option[String] = None,
  partition : Option[Int] = None,
  readOnly : Option[Boolean] = None
) {

  /** Returns a new data with pdName set to new value */
  def withPdName(value: String) : GCEPersistentDiskVolumeSource = copy(pdName = value)
  /** transforms pdName to result of function */
  def mapPdName(f: String => String) : GCEPersistentDiskVolumeSource = copy(pdName = f(pdName))

  /** Returns a new data with fsType set to new value */
  def withFsType(value: String) : GCEPersistentDiskVolumeSource = copy(fsType = Some(value))
  /** if fsType has a value, transforms to the result of function*/
  def mapFsType(f: String => String) : GCEPersistentDiskVolumeSource = copy(fsType = fsType.map(f))

  /** Returns a new data with partition set to new value */
  def withPartition(value: Int) : GCEPersistentDiskVolumeSource = copy(partition = Some(value))
  /** if partition has a value, transforms to the result of function*/
  def mapPartition(f: Int => Int) : GCEPersistentDiskVolumeSource = copy(partition = partition.map(f))

  /** Returns a new data with readOnly set to new value */
  def withReadOnly(value: Boolean) : GCEPersistentDiskVolumeSource = copy(readOnly = Some(value))
  /** if readOnly has a value, transforms to the result of function*/
  def mapReadOnly(f: Boolean => Boolean) : GCEPersistentDiskVolumeSource = copy(readOnly = readOnly.map(f))
}

