package io.k8s.api.core.v1


/** Represents a Flocker volume mounted by the Flocker agent. One and only one of datasetName and datasetUUID should be set. Flocker volumes do not support ownership management or SELinux relabeling. */
final case class FlockerVolumeSource(
  datasetName : Option[String] = None,
  datasetUUID : Option[String] = None
) {

  /** Returns a new data with datasetName set to new value */
  def withDatasetName(value: String) : FlockerVolumeSource = copy(datasetName = Some(value))
  /** if datasetName has a value, transforms to the result of function*/
  def mapDatasetName(f: String => String) : FlockerVolumeSource = copy(datasetName = datasetName.map(f))

  /** Returns a new data with datasetUUID set to new value */
  def withDatasetUUID(value: String) : FlockerVolumeSource = copy(datasetUUID = Some(value))
  /** if datasetUUID has a value, transforms to the result of function*/
  def mapDatasetUUID(f: String => String) : FlockerVolumeSource = copy(datasetUUID = datasetUUID.map(f))
}

