package io.k8s.api.core.v1


/** EndpointAddress is a tuple that describes single IP address. */
final case class EndpointAddress(
  ip : String,
  hostname : Option[String] = None,
  nodeName : Option[String] = None,
  targetRef : Option[io.k8s.api.core.v1.ObjectReference] = None
) {

  /** Returns a new data with ip set to new value */
  def withIp(value: String) : EndpointAddress = copy(ip = value)
  /** transforms ip to result of function */
  def mapIp(f: String => String) : EndpointAddress = copy(ip = f(ip))

  /** Returns a new data with hostname set to new value */
  def withHostname(value: String) : EndpointAddress = copy(hostname = Some(value))
  /** if hostname has a value, transforms to the result of function*/
  def mapHostname(f: String => String) : EndpointAddress = copy(hostname = hostname.map(f))

  /** Returns a new data with nodeName set to new value */
  def withNodeName(value: String) : EndpointAddress = copy(nodeName = Some(value))
  /** if nodeName has a value, transforms to the result of function*/
  def mapNodeName(f: String => String) : EndpointAddress = copy(nodeName = nodeName.map(f))

  /** Returns a new data with targetRef set to new value */
  def withTargetRef(value: io.k8s.api.core.v1.ObjectReference) : EndpointAddress = copy(targetRef = Some(value))
  /** if targetRef has a value, transforms to the result of function*/
  def mapTargetRef(f: io.k8s.api.core.v1.ObjectReference => io.k8s.api.core.v1.ObjectReference) : EndpointAddress = copy(targetRef = targetRef.map(f))
}

