package io.k8s.api.core.v1


/** Information about the condition of a component. */
final case class ComponentCondition(
  status : String,
  `type` : String,
  error : Option[String] = None,
  message : Option[String] = None
) {

  /** Returns a new data with status set to new value */
  def withStatus(value: String) : ComponentCondition = copy(status = value)
  /** transforms status to result of function */
  def mapStatus(f: String => String) : ComponentCondition = copy(status = f(status))

  /** Returns a new data with `type` set to new value */
  def withType(value: String) : ComponentCondition = copy(`type` = value)
  /** transforms `type` to result of function */
  def mapType(f: String => String) : ComponentCondition = copy(`type` = f(`type`))

  /** Returns a new data with error set to new value */
  def withError(value: String) : ComponentCondition = copy(error = Some(value))
  /** if error has a value, transforms to the result of function*/
  def mapError(f: String => String) : ComponentCondition = copy(error = error.map(f))

  /** Returns a new data with message set to new value */
  def withMessage(value: String) : ComponentCondition = copy(message = Some(value))
  /** if message has a value, transforms to the result of function*/
  def mapMessage(f: String => String) : ComponentCondition = copy(message = message.map(f))
}

