package io.k8s.api.core.v1


/** AzureDisk represents an Azure Data Disk mount on the host and bind mount to the pod. */
final case class AzureDiskVolumeSource(
  diskURI : String,
  diskName : String,
  readOnly : Option[Boolean] = None,
  fsType : Option[String] = None,
  cachingMode : Option[String] = None
) {

  /** Returns a new data with diskURI set to new value */
  def withDiskURI(value: String) : AzureDiskVolumeSource = copy(diskURI = value)
  /** transforms diskURI to result of function */
  def mapDiskURI(f: String => String) : AzureDiskVolumeSource = copy(diskURI = f(diskURI))

  /** Returns a new data with diskName set to new value */
  def withDiskName(value: String) : AzureDiskVolumeSource = copy(diskName = value)
  /** transforms diskName to result of function */
  def mapDiskName(f: String => String) : AzureDiskVolumeSource = copy(diskName = f(diskName))

  /** Returns a new data with readOnly set to new value */
  def withReadOnly(value: Boolean) : AzureDiskVolumeSource = copy(readOnly = Some(value))
  /** if readOnly has a value, transforms to the result of function*/
  def mapReadOnly(f: Boolean => Boolean) : AzureDiskVolumeSource = copy(readOnly = readOnly.map(f))

  /** Returns a new data with fsType set to new value */
  def withFsType(value: String) : AzureDiskVolumeSource = copy(fsType = Some(value))
  /** if fsType has a value, transforms to the result of function*/
  def mapFsType(f: String => String) : AzureDiskVolumeSource = copy(fsType = fsType.map(f))

  /** Returns a new data with cachingMode set to new value */
  def withCachingMode(value: String) : AzureDiskVolumeSource = copy(cachingMode = Some(value))
  /** if cachingMode has a value, transforms to the result of function*/
  def mapCachingMode(f: String => String) : AzureDiskVolumeSource = copy(cachingMode = cachingMode.map(f))
}

