package io.k8s.api.autoscaling.v2beta2


/** HorizontalPodAutoscalerSpec describes the desired functionality of the HorizontalPodAutoscaler. */
final case class HorizontalPodAutoscalerSpec(
  maxReplicas : Int,
  scaleTargetRef : io.k8s.api.autoscaling.v2beta2.CrossVersionObjectReference,
  minReplicas : Option[Int] = None,
  metrics : Option[Seq[io.k8s.api.autoscaling.v2beta2.MetricSpec]] = None,
  behavior : Option[io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscalerBehavior] = None
) {

  /** Returns a new data with maxReplicas set to new value */
  def withMaxReplicas(value: Int) : HorizontalPodAutoscalerSpec = copy(maxReplicas = value)
  /** transforms maxReplicas to result of function */
  def mapMaxReplicas(f: Int => Int) : HorizontalPodAutoscalerSpec = copy(maxReplicas = f(maxReplicas))

  /** Returns a new data with scaleTargetRef set to new value */
  def withScaleTargetRef(value: io.k8s.api.autoscaling.v2beta2.CrossVersionObjectReference) : HorizontalPodAutoscalerSpec = copy(scaleTargetRef = value)
  /** transforms scaleTargetRef to result of function */
  def mapScaleTargetRef(f: io.k8s.api.autoscaling.v2beta2.CrossVersionObjectReference => io.k8s.api.autoscaling.v2beta2.CrossVersionObjectReference) : HorizontalPodAutoscalerSpec = copy(scaleTargetRef = f(scaleTargetRef))

  /** Returns a new data with minReplicas set to new value */
  def withMinReplicas(value: Int) : HorizontalPodAutoscalerSpec = copy(minReplicas = Some(value))
  /** if minReplicas has a value, transforms to the result of function*/
  def mapMinReplicas(f: Int => Int) : HorizontalPodAutoscalerSpec = copy(minReplicas = minReplicas.map(f))

  /** Returns a new data with metrics set to new value */
  def withMetrics(value: Seq[io.k8s.api.autoscaling.v2beta2.MetricSpec]) : HorizontalPodAutoscalerSpec = copy(metrics = Some(value))
  /** Appends new values to metrics */
  def addMetrics(newValues: io.k8s.api.autoscaling.v2beta2.MetricSpec*) : HorizontalPodAutoscalerSpec = copy(metrics = Some(metrics.fold(newValues)(_ ++ newValues)))
  /** if metrics has a value, transforms to the result of function*/
  def mapMetrics(f: Seq[io.k8s.api.autoscaling.v2beta2.MetricSpec] => Seq[io.k8s.api.autoscaling.v2beta2.MetricSpec]) : HorizontalPodAutoscalerSpec = copy(metrics = metrics.map(f))

  /** Returns a new data with behavior set to new value */
  def withBehavior(value: io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscalerBehavior) : HorizontalPodAutoscalerSpec = copy(behavior = Some(value))
  /** if behavior has a value, transforms to the result of function*/
  def mapBehavior(f: io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscalerBehavior => io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscalerBehavior) : HorizontalPodAutoscalerSpec = copy(behavior = behavior.map(f))
}

