package io.k8s.api.autoscaling.v2beta2

import dev.hnaderi.k8s._

/** HorizontalPodAutoscaler is the configuration for a horizontal pod autoscaler, which automatically manages the replica count of any resource implementing the scale subresource based on the metrics specified. */
final case class HorizontalPodAutoscaler(
  status : Option[io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscalerStatus] = None,
  spec : Option[io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscalerSpec] = None,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("autoscaling", "HorizontalPodAutoscaler", "v2beta2")


  /** Returns a new data with status set to new value */
  def withStatus(value: io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscalerStatus) : HorizontalPodAutoscaler = copy(status = Some(value))
  /** if status has a value, transforms to the result of function*/
  def mapStatus(f: io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscalerStatus => io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscalerStatus) : HorizontalPodAutoscaler = copy(status = status.map(f))

  /** Returns a new data with spec set to new value */
  def withSpec(value: io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscalerSpec) : HorizontalPodAutoscaler = copy(spec = Some(value))
  /** if spec has a value, transforms to the result of function*/
  def mapSpec(f: io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscalerSpec => io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscalerSpec) : HorizontalPodAutoscaler = copy(spec = spec.map(f))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : HorizontalPodAutoscaler = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : HorizontalPodAutoscaler = copy(metadata = metadata.map(f))
}

