package io.k8s.api.autoscaling.v2beta2


/** HPAScalingPolicy is a single policy which must hold true for a specified past interval. */
final case class HPAScalingPolicy(
  periodSeconds : Int,
  `type` : String,
  value : Int
) {

  /** Returns a new data with periodSeconds set to new value */
  def withPeriodSeconds(value: Int) : HPAScalingPolicy = copy(periodSeconds = value)
  /** transforms periodSeconds to result of function */
  def mapPeriodSeconds(f: Int => Int) : HPAScalingPolicy = copy(periodSeconds = f(periodSeconds))

  /** Returns a new data with `type` set to new value */
  def withType(value: String) : HPAScalingPolicy = copy(`type` = value)
  /** transforms `type` to result of function */
  def mapType(f: String => String) : HPAScalingPolicy = copy(`type` = f(`type`))

  /** Returns a new data with value set to new value */
  def withValue(value: Int) : HPAScalingPolicy = copy(value = value)
  /** transforms value to result of function */
  def mapValue(f: Int => Int) : HPAScalingPolicy = copy(value = f(value))
}

