package io.k8s.api.autoscaling.v1


/** ScaleStatus represents the current status of a scale subresource. */
final case class ScaleStatus(
  replicas : Int,
  selector : Option[String] = None
) {

  /** Returns a new data with replicas set to new value */
  def withReplicas(value: Int) : ScaleStatus = copy(replicas = value)
  /** transforms replicas to result of function */
  def mapReplicas(f: Int => Int) : ScaleStatus = copy(replicas = f(replicas))

  /** Returns a new data with selector set to new value */
  def withSelector(value: String) : ScaleStatus = copy(selector = Some(value))
  /** if selector has a value, transforms to the result of function*/
  def mapSelector(f: String => String) : ScaleStatus = copy(selector = selector.map(f))
}

