package io.k8s.api.authentication.v1


/** TokenRequestStatus is the result of a token request. */
final case class TokenRequestStatus(
  expirationTimestamp : io.k8s.apimachinery.pkg.apis.meta.v1.Time,
  token : String
) {

  /** Returns a new data with expirationTimestamp set to new value */
  def withExpirationTimestamp(value: io.k8s.apimachinery.pkg.apis.meta.v1.Time) : TokenRequestStatus = copy(expirationTimestamp = value)
  /** transforms expirationTimestamp to result of function */
  def mapExpirationTimestamp(f: io.k8s.apimachinery.pkg.apis.meta.v1.Time => io.k8s.apimachinery.pkg.apis.meta.v1.Time) : TokenRequestStatus = copy(expirationTimestamp = f(expirationTimestamp))

  /** Returns a new data with token set to new value */
  def withToken(value: String) : TokenRequestStatus = copy(token = value)
  /** transforms token to result of function */
  def mapToken(f: String => String) : TokenRequestStatus = copy(token = f(token))
}

