package io.k8s.api.authentication.v1

import dev.hnaderi.k8s._

/** TokenRequest requests a token for a given service account. */
final case class TokenRequest(
  spec : io.k8s.api.authentication.v1.TokenRequestSpec,
  status : Option[io.k8s.api.authentication.v1.TokenRequestStatus] = None,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("authentication.k8s.io", "TokenRequest", "v1")


  /** Returns a new data with spec set to new value */
  def withSpec(value: io.k8s.api.authentication.v1.TokenRequestSpec) : TokenRequest = copy(spec = value)
  /** transforms spec to result of function */
  def mapSpec(f: io.k8s.api.authentication.v1.TokenRequestSpec => io.k8s.api.authentication.v1.TokenRequestSpec) : TokenRequest = copy(spec = f(spec))

  /** Returns a new data with status set to new value */
  def withStatus(value: io.k8s.api.authentication.v1.TokenRequestStatus) : TokenRequest = copy(status = Some(value))
  /** if status has a value, transforms to the result of function*/
  def mapStatus(f: io.k8s.api.authentication.v1.TokenRequestStatus => io.k8s.api.authentication.v1.TokenRequestStatus) : TokenRequest = copy(status = status.map(f))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : TokenRequest = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : TokenRequest = copy(metadata = metadata.map(f))
}

