package io.k8s.api.apiserverinternal.v1alpha1


/** API server instances report the versions they can decode and the version they encode objects to when persisting objects in the backend. */
final case class StorageVersionStatus(
  commonEncodingVersion : Option[String] = None,
  conditions : Option[Seq[io.k8s.api.apiserverinternal.v1alpha1.StorageVersionCondition]] = None,
  storageVersions : Option[Seq[io.k8s.api.apiserverinternal.v1alpha1.ServerStorageVersion]] = None
) {

  /** Returns a new data with commonEncodingVersion set to new value */
  def withCommonEncodingVersion(value: String) : StorageVersionStatus = copy(commonEncodingVersion = Some(value))
  /** if commonEncodingVersion has a value, transforms to the result of function*/
  def mapCommonEncodingVersion(f: String => String) : StorageVersionStatus = copy(commonEncodingVersion = commonEncodingVersion.map(f))

  /** Returns a new data with conditions set to new value */
  def withConditions(value: Seq[io.k8s.api.apiserverinternal.v1alpha1.StorageVersionCondition]) : StorageVersionStatus = copy(conditions = Some(value))
  /** Appends new values to conditions */
  def addConditions(newValues: io.k8s.api.apiserverinternal.v1alpha1.StorageVersionCondition*) : StorageVersionStatus = copy(conditions = Some(conditions.fold(newValues)(_ ++ newValues)))
  /** if conditions has a value, transforms to the result of function*/
  def mapConditions(f: Seq[io.k8s.api.apiserverinternal.v1alpha1.StorageVersionCondition] => Seq[io.k8s.api.apiserverinternal.v1alpha1.StorageVersionCondition]) : StorageVersionStatus = copy(conditions = conditions.map(f))

  /** Returns a new data with storageVersions set to new value */
  def withStorageVersions(value: Seq[io.k8s.api.apiserverinternal.v1alpha1.ServerStorageVersion]) : StorageVersionStatus = copy(storageVersions = Some(value))
  /** Appends new values to storageVersions */
  def addStorageVersions(newValues: io.k8s.api.apiserverinternal.v1alpha1.ServerStorageVersion*) : StorageVersionStatus = copy(storageVersions = Some(storageVersions.fold(newValues)(_ ++ newValues)))
  /** if storageVersions has a value, transforms to the result of function*/
  def mapStorageVersions(f: Seq[io.k8s.api.apiserverinternal.v1alpha1.ServerStorageVersion] => Seq[io.k8s.api.apiserverinternal.v1alpha1.ServerStorageVersion]) : StorageVersionStatus = copy(storageVersions = storageVersions.map(f))
}

