package io.k8s.api.admissionregistration.v1


/** WebhookClientConfig contains the information to make a TLS connection with the webhook */
final case class WebhookClientConfig(
  caBundle : Option[String] = None,
  service : Option[io.k8s.api.admissionregistration.v1.ServiceReference] = None,
  url : Option[String] = None
) {

  /** Returns a new data with caBundle set to new value */
  def withCaBundle(value: String) : WebhookClientConfig = copy(caBundle = Some(value))
  /** if caBundle has a value, transforms to the result of function*/
  def mapCaBundle(f: String => String) : WebhookClientConfig = copy(caBundle = caBundle.map(f))

  /** Returns a new data with service set to new value */
  def withService(value: io.k8s.api.admissionregistration.v1.ServiceReference) : WebhookClientConfig = copy(service = Some(value))
  /** if service has a value, transforms to the result of function*/
  def mapService(f: io.k8s.api.admissionregistration.v1.ServiceReference => io.k8s.api.admissionregistration.v1.ServiceReference) : WebhookClientConfig = copy(service = service.map(f))

  /** Returns a new data with url set to new value */
  def withUrl(value: String) : WebhookClientConfig = copy(url = Some(value))
  /** if url has a value, transforms to the result of function*/
  def mapUrl(f: String => String) : WebhookClientConfig = copy(url = url.map(f))
}

