package io.k8s.api.apps.v1

import dev.hnaderi.k8s.utils._

/** ReplicaSetCondition describes the state of a replica set at a certain point. */
final case class ReplicaSetCondition(
  status : String,
  `type` : String,
  reason : Option[String] = None,
  lastTransitionTime : Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None,
  message : Option[String] = None
) {

  /** Returns a new data with status set to new value */
  def withStatus(value: String) : ReplicaSetCondition = copy(status = value)
  /** transforms status to result of function */
  def mapStatus(f: String => String) : ReplicaSetCondition = copy(status = f(status))

  /** Returns a new data with `type` set to new value */
  def withType(value: String) : ReplicaSetCondition = copy(`type` = value)
  /** transforms `type` to result of function */
  def mapType(f: String => String) : ReplicaSetCondition = copy(`type` = f(`type`))

  /** Returns a new data with reason set to new value */
  def withReason(value: String) : ReplicaSetCondition = copy(reason = Some(value))
  /** if reason has a value, transforms to the result of function*/
  def mapReason(f: String => String) : ReplicaSetCondition = copy(reason = reason.map(f))

  /** Returns a new data with lastTransitionTime set to new value */
  def withLastTransitionTime(value: io.k8s.apimachinery.pkg.apis.meta.v1.Time) : ReplicaSetCondition = copy(lastTransitionTime = Some(value))
  /** if lastTransitionTime has a value, transforms to the result of function*/
  def mapLastTransitionTime(f: io.k8s.apimachinery.pkg.apis.meta.v1.Time => io.k8s.apimachinery.pkg.apis.meta.v1.Time) : ReplicaSetCondition = copy(lastTransitionTime = lastTransitionTime.map(f))

  /** Returns a new data with message set to new value */
  def withMessage(value: String) : ReplicaSetCondition = copy(message = Some(value))
  /** if message has a value, transforms to the result of function*/
  def mapMessage(f: String => String) : ReplicaSetCondition = copy(message = message.map(f))
}

object ReplicaSetCondition {

    implicit val encoder : Encoder[io.k8s.api.apps.v1.ReplicaSetCondition] = new Encoder[io.k8s.api.apps.v1.ReplicaSetCondition] {
        def apply[T : Builder](o: io.k8s.api.apps.v1.ReplicaSetCondition) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("status", o.status)
            .write("type", o.`type`)
            .write("reason", o.reason)
            .write("lastTransitionTime", o.lastTransitionTime)
            .write("message", o.message)
            .build
        }
    }

    implicit val decoder: Decoder[ReplicaSetCondition] = new Decoder[ReplicaSetCondition] {
      def apply[T : Reader](t: T): Either[String, ReplicaSetCondition] = for {
          obj <- ObjectReader(t)
          status <- obj.read[String]("status")
          `type` <- obj.read[String]("type")
          reason <- obj.readOpt[String]("reason")
          lastTransitionTime <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.Time]("lastTransitionTime")
          message <- obj.readOpt[String]("message")
      } yield ReplicaSetCondition (
          status = status,
          `type` = `type`,
          reason = reason,
          lastTransitionTime = lastTransitionTime,
          message = message
        )
    }
}

