package io.k8s.api.storage.v1alpha1

import dev.hnaderi.k8s._
import dev.hnaderi.k8s.utils._

/** VolumeAttributesClass represents a specification of mutable volume attributes defined by the CSI driver. The class can be specified during dynamic provisioning of PersistentVolumeClaims, and changed in the PersistentVolumeClaim spec after provisioning. */
final case class VolumeAttributesClass(
  driverName : String,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None,
  parameters : Option[Map[String, String]] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("storage.k8s.io", "VolumeAttributesClass", "v1alpha1")


  /** Returns a new data with driverName set to new value */
  def withDriverName(value: String) : VolumeAttributesClass = copy(driverName = value)
  /** transforms driverName to result of function */
  def mapDriverName(f: String => String) : VolumeAttributesClass = copy(driverName = f(driverName))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : VolumeAttributesClass = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : VolumeAttributesClass = copy(metadata = metadata.map(f))

  /** Returns a new data with parameters set to new value */
  def withParameters(value: Map[String, String]) : VolumeAttributesClass = copy(parameters = Some(value))
  /** Adds new values to parameters */
  def addParameters(newValues: (String, String)*) : VolumeAttributesClass = copy(parameters = Some(parameters.fold(newValues.toMap)(_ ++ newValues)))
  /** if parameters has a value, transforms to the result of function*/
  def mapParameters(f: Map[String, String] => Map[String, String]) : VolumeAttributesClass = copy(parameters = parameters.map(f))

  override def foldTo[T : Builder] : T = VolumeAttributesClass.encoder.apply(this)
}

object VolumeAttributesClass {

    implicit val encoder : Encoder[io.k8s.api.storage.v1alpha1.VolumeAttributesClass] = new Encoder[io.k8s.api.storage.v1alpha1.VolumeAttributesClass] {
        def apply[T : Builder](o: io.k8s.api.storage.v1alpha1.VolumeAttributesClass) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("driverName", o.driverName)
            .write("metadata", o.metadata)
            .write("parameters", o.parameters)
            .write("kind", o.kind)
            .write("apiVersion", o.apiVersion)
            .build
        }
    }

    implicit val decoder: Decoder[VolumeAttributesClass] = new Decoder[VolumeAttributesClass] {
      def apply[T : Reader](t: T): Either[String, VolumeAttributesClass] = for {
          obj <- ObjectReader(t)
          driverName <- obj.read[String]("driverName")
          metadata <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]("metadata")
          parameters <- obj.readOpt[Map[String, String]]("parameters")
      } yield VolumeAttributesClass (
          driverName = driverName,
          metadata = metadata,
          parameters = parameters
        )
    }
}

