package io.k8s.api.networking.v1

import dev.hnaderi.k8s.utils._

/** IngressTLS describes the transport layer security associated with an ingress. */
final case class IngressTLS(
  hosts : Option[Seq[String]] = None,
  secretName : Option[String] = None
) {

  /** Returns a new data with hosts set to new value */
  def withHosts(value: Seq[String]) : IngressTLS = copy(hosts = Some(value))
  /** Appends new values to hosts */
  def addHosts(newValues: String*) : IngressTLS = copy(hosts = Some(hosts.fold(newValues)(_ ++ newValues)))
  /** if hosts has a value, transforms to the result of function*/
  def mapHosts(f: Seq[String] => Seq[String]) : IngressTLS = copy(hosts = hosts.map(f))

  /** Returns a new data with secretName set to new value */
  def withSecretName(value: String) : IngressTLS = copy(secretName = Some(value))
  /** if secretName has a value, transforms to the result of function*/
  def mapSecretName(f: String => String) : IngressTLS = copy(secretName = secretName.map(f))
}

object IngressTLS {

    implicit val encoder : Encoder[io.k8s.api.networking.v1.IngressTLS] = new Encoder[io.k8s.api.networking.v1.IngressTLS] {
        def apply[T : Builder](o: io.k8s.api.networking.v1.IngressTLS) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("hosts", o.hosts)
            .write("secretName", o.secretName)
            .build
        }
    }

    implicit val decoder: Decoder[IngressTLS] = new Decoder[IngressTLS] {
      def apply[T : Reader](t: T): Either[String, IngressTLS] = for {
          obj <- ObjectReader(t)
          hosts <- obj.readOpt[Seq[String]]("hosts")
          secretName <- obj.readOpt[String]("secretName")
      } yield IngressTLS (
          hosts = hosts,
          secretName = secretName
        )
    }
}

