package io.k8s.api.batch.v1

import dev.hnaderi.k8s.utils._

/** PodFailurePolicy describes how failed pods influence the backoffLimit. */
final case class PodFailurePolicy(
  rules : Seq[io.k8s.api.batch.v1.PodFailurePolicyRule]
) {

  /** Returns a new data with rules set to new value */
  def withRules(value: Seq[io.k8s.api.batch.v1.PodFailurePolicyRule]) : PodFailurePolicy = copy(rules = value)
  /** Appends new values to rules */
  def addRules(newValues: io.k8s.api.batch.v1.PodFailurePolicyRule*) : PodFailurePolicy = copy(rules = rules ++ newValues)
  /** transforms rules to result of function */
  def mapRules(f: Seq[io.k8s.api.batch.v1.PodFailurePolicyRule] => Seq[io.k8s.api.batch.v1.PodFailurePolicyRule]) : PodFailurePolicy = copy(rules = f(rules))
}

object PodFailurePolicy {

    implicit val encoder : Encoder[io.k8s.api.batch.v1.PodFailurePolicy] = new Encoder[io.k8s.api.batch.v1.PodFailurePolicy] {
        def apply[T : Builder](o: io.k8s.api.batch.v1.PodFailurePolicy) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("rules", o.rules)
            .build
        }
    }

    implicit val decoder: Decoder[PodFailurePolicy] = new Decoder[PodFailurePolicy] {
      def apply[T : Reader](t: T): Either[String, PodFailurePolicy] = for {
          obj <- ObjectReader(t)
          rules <- obj.read[Seq[io.k8s.api.batch.v1.PodFailurePolicyRule]]("rules")
      } yield PodFailurePolicy (
          rules = rules
        )
    }
}

