package io.k8s.api.core.v1

import dev.hnaderi.k8s.utils._

/** PodIP represents a single IP address allocated to the pod. */
final case class PodIP(
  ip : Option[String] = None
) {

  /** Returns a new data with ip set to new value */
  def withIp(value: String) : PodIP = copy(ip = Some(value))
  /** if ip has a value, transforms to the result of function*/
  def mapIp(f: String => String) : PodIP = copy(ip = ip.map(f))
}

object PodIP {

    implicit val encoder : Encoder[io.k8s.api.core.v1.PodIP] = new Encoder[io.k8s.api.core.v1.PodIP] {
        def apply[T : Builder](o: io.k8s.api.core.v1.PodIP) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("ip", o.ip)
            .build
        }
    }

    implicit val decoder: Decoder[PodIP] = new Decoder[PodIP] {
      def apply[T : Reader](t: T): Either[String, PodIP] = for {
          obj <- ObjectReader(t)
          ip <- obj.readOpt[String]("ip")
      } yield PodIP (
          ip = ip
        )
    }
}

