package io.k8s.apimachinery.pkg.apis.meta.v1

import dev.hnaderi.k8s.utils._

/** Condition contains details for one aspect of the current state of this API Resource. */
final case class Condition(
  reason : String,
  status : String,
  lastTransitionTime : io.k8s.apimachinery.pkg.apis.meta.v1.Time,
  message : String,
  `type` : String,
  observedGeneration : Option[Long] = None
) {

  /** Returns a new data with reason set to new value */
  def withReason(value: String) : Condition = copy(reason = value)
  /** transforms reason to result of function */
  def mapReason(f: String => String) : Condition = copy(reason = f(reason))

  /** Returns a new data with status set to new value */
  def withStatus(value: String) : Condition = copy(status = value)
  /** transforms status to result of function */
  def mapStatus(f: String => String) : Condition = copy(status = f(status))

  /** Returns a new data with lastTransitionTime set to new value */
  def withLastTransitionTime(value: io.k8s.apimachinery.pkg.apis.meta.v1.Time) : Condition = copy(lastTransitionTime = value)
  /** transforms lastTransitionTime to result of function */
  def mapLastTransitionTime(f: io.k8s.apimachinery.pkg.apis.meta.v1.Time => io.k8s.apimachinery.pkg.apis.meta.v1.Time) : Condition = copy(lastTransitionTime = f(lastTransitionTime))

  /** Returns a new data with message set to new value */
  def withMessage(value: String) : Condition = copy(message = value)
  /** transforms message to result of function */
  def mapMessage(f: String => String) : Condition = copy(message = f(message))

  /** Returns a new data with `type` set to new value */
  def withType(value: String) : Condition = copy(`type` = value)
  /** transforms `type` to result of function */
  def mapType(f: String => String) : Condition = copy(`type` = f(`type`))

  /** Returns a new data with observedGeneration set to new value */
  def withObservedGeneration(value: Long) : Condition = copy(observedGeneration = Some(value))
  /** if observedGeneration has a value, transforms to the result of function*/
  def mapObservedGeneration(f: Long => Long) : Condition = copy(observedGeneration = observedGeneration.map(f))
}

object Condition {

    implicit val encoder : Encoder[io.k8s.apimachinery.pkg.apis.meta.v1.Condition] = new Encoder[io.k8s.apimachinery.pkg.apis.meta.v1.Condition] {
        def apply[T : Builder](o: io.k8s.apimachinery.pkg.apis.meta.v1.Condition) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("reason", o.reason)
            .write("status", o.status)
            .write("lastTransitionTime", o.lastTransitionTime)
            .write("message", o.message)
            .write("type", o.`type`)
            .write("observedGeneration", o.observedGeneration)
            .build
        }
    }

    implicit val decoder: Decoder[Condition] = new Decoder[Condition] {
      def apply[T : Reader](t: T): Either[String, Condition] = for {
          obj <- ObjectReader(t)
          reason <- obj.read[String]("reason")
          status <- obj.read[String]("status")
          lastTransitionTime <- obj.read[io.k8s.apimachinery.pkg.apis.meta.v1.Time]("lastTransitionTime")
          message <- obj.read[String]("message")
          `type` <- obj.read[String]("type")
          observedGeneration <- obj.readOpt[Long]("observedGeneration")
      } yield Condition (
          reason = reason,
          status = status,
          lastTransitionTime = lastTransitionTime,
          message = message,
          `type` = `type`,
          observedGeneration = observedGeneration
        )
    }
}

