package io.k8s.apimachinery.pkg.apis.meta.v1


/** ServerAddressByClientCIDR helps the client to determine the server address that they should use, depending on the clientCIDR that they match. */
final case class ServerAddressByClientCIDR(
  clientCIDR : String,
  serverAddress : String
) {

  /** Returns a new data with clientCIDR set to new value */
  def withClientCIDR(value: String) : ServerAddressByClientCIDR = copy(clientCIDR = value)
  /** transforms clientCIDR to result of function */
  def mapClientCIDR(f: String => String) : ServerAddressByClientCIDR = copy(clientCIDR = f(clientCIDR))

  /** Returns a new data with serverAddress set to new value */
  def withServerAddress(value: String) : ServerAddressByClientCIDR = copy(serverAddress = value)
  /** transforms serverAddress to result of function */
  def mapServerAddress(f: String => String) : ServerAddressByClientCIDR = copy(serverAddress = f(serverAddress))
}

