package io.k8s.apimachinery.pkg.apis.meta.v1

import dev.hnaderi.k8s._

/** APIGroup contains the name, the supported versions, and the preferred version of a group. */
final case class APIGroup(
  name : String,
  versions : Seq[io.k8s.apimachinery.pkg.apis.meta.v1.GroupVersionForDiscovery],
  preferredVersion : Option[io.k8s.apimachinery.pkg.apis.meta.v1.GroupVersionForDiscovery] = None,
  serverAddressByClientCIDRs : Option[Seq[io.k8s.apimachinery.pkg.apis.meta.v1.ServerAddressByClientCIDR]] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("", "APIGroup", "v1")


  /** Returns a new data with name set to new value */
  def withName(value: String) : APIGroup = copy(name = value)
  /** transforms name to result of function */
  def mapName(f: String => String) : APIGroup = copy(name = f(name))

  /** Returns a new data with versions set to new value */
  def withVersions(value: Seq[io.k8s.apimachinery.pkg.apis.meta.v1.GroupVersionForDiscovery]) : APIGroup = copy(versions = value)
  /** Appends new values to versions */
  def addVersions(newValues: io.k8s.apimachinery.pkg.apis.meta.v1.GroupVersionForDiscovery*) : APIGroup = copy(versions = versions ++ newValues)
  /** transforms versions to result of function */
  def mapVersions(f: Seq[io.k8s.apimachinery.pkg.apis.meta.v1.GroupVersionForDiscovery] => Seq[io.k8s.apimachinery.pkg.apis.meta.v1.GroupVersionForDiscovery]) : APIGroup = copy(versions = f(versions))

  /** Returns a new data with preferredVersion set to new value */
  def withPreferredVersion(value: io.k8s.apimachinery.pkg.apis.meta.v1.GroupVersionForDiscovery) : APIGroup = copy(preferredVersion = Some(value))
  /** if preferredVersion has a value, transforms to the result of function*/
  def mapPreferredVersion(f: io.k8s.apimachinery.pkg.apis.meta.v1.GroupVersionForDiscovery => io.k8s.apimachinery.pkg.apis.meta.v1.GroupVersionForDiscovery) : APIGroup = copy(preferredVersion = preferredVersion.map(f))

  /** Returns a new data with serverAddressByClientCIDRs set to new value */
  def withServerAddressByClientCIDRs(value: Seq[io.k8s.apimachinery.pkg.apis.meta.v1.ServerAddressByClientCIDR]) : APIGroup = copy(serverAddressByClientCIDRs = Some(value))
  /** Appends new values to serverAddressByClientCIDRs */
  def addServerAddressByClientCIDRs(newValues: io.k8s.apimachinery.pkg.apis.meta.v1.ServerAddressByClientCIDR*) : APIGroup = copy(serverAddressByClientCIDRs = Some(serverAddressByClientCIDRs.fold(newValues)(_ ++ newValues)))
  /** if serverAddressByClientCIDRs has a value, transforms to the result of function*/
  def mapServerAddressByClientCIDRs(f: Seq[io.k8s.apimachinery.pkg.apis.meta.v1.ServerAddressByClientCIDR] => Seq[io.k8s.apimachinery.pkg.apis.meta.v1.ServerAddressByClientCIDR]) : APIGroup = copy(serverAddressByClientCIDRs = serverAddressByClientCIDRs.map(f))
}

