package io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1


/** ValidationRule describes a validation rule written in the CEL expression language. */
final case class ValidationRule(
  rule : String,
  message : Option[String] = None
) {

  /** Returns a new data with rule set to new value */
  def withRule(value: String) : ValidationRule = copy(rule = value)
  /** transforms rule to result of function */
  def mapRule(f: String => String) : ValidationRule = copy(rule = f(rule))

  /** Returns a new data with message set to new value */
  def withMessage(value: String) : ValidationRule = copy(message = Some(value))
  /** if message has a value, transforms to the result of function*/
  def mapMessage(f: String => String) : ValidationRule = copy(message = message.map(f))
}

