package io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1


/** JSONSchemaProps is a JSON-Schema following Specification Draft 4 (http://json-schema.org/). */
final case class JSONSchemaProps(
  exclusiveMaximum : Option[Boolean] = None,
  format : Option[String] = None,
  ref : Option[String] = None,
  nullable : Option[Boolean] = None,
  `x-kubernetes-map-type` : Option[String] = None,
  pattern : Option[String] = None,
  description : Option[String] = None,
  anyOf : Option[Seq[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps]] = None,
  `x-kubernetes-list-type` : Option[String] = None,
  patternProperties : Option[Map[String, io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps]] = None,
  items : Option[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaPropsOrArray] = None,
  additionalItems : Option[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaPropsOrBool] = None,
  maxProperties : Option[Int] = None,
  maxItems : Option[Int] = None,
  `x-kubernetes-int-or-string` : Option[Boolean] = None,
  `x-kubernetes-embedded-resource` : Option[Boolean] = None,
  maximum : Option[Double] = None,
  multipleOf : Option[Double] = None,
  id : Option[String] = None,
  properties : Option[Map[String, io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps]] = None,
  exclusiveMinimum : Option[Boolean] = None,
  `x-kubernetes-validations` : Option[Seq[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.ValidationRule]] = None,
  `enum` : Option[Seq[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSON]] = None,
  `x-kubernetes-preserve-unknown-fields` : Option[Boolean] = None,
  additionalProperties : Option[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaPropsOrBool] = None,
  default : Option[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSON] = None,
  minItems : Option[Int] = None,
  not : Option[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps] = None,
  definitions : Option[Map[String, io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps]] = None,
  minLength : Option[Int] = None,
  `x-kubernetes-list-map-keys` : Option[Seq[String]] = None,
  title : Option[String] = None,
  minimum : Option[Double] = None,
  `type` : Option[String] = None,
  required : Option[Seq[String]] = None,
  example : Option[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSON] = None,
  schema : Option[String] = None,
  oneOf : Option[Seq[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps]] = None,
  uniqueItems : Option[Boolean] = None,
  minProperties : Option[Int] = None,
  dependencies : Option[Map[String, io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaPropsOrStringArray]] = None,
  externalDocs : Option[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.ExternalDocumentation] = None,
  maxLength : Option[Int] = None,
  allOf : Option[Seq[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps]] = None
) {

  /** Returns a new data with exclusiveMaximum set to new value */
  def withExclusiveMaximum(value: Boolean) : JSONSchemaProps = copy(exclusiveMaximum = Some(value))
  /** if exclusiveMaximum has a value, transforms to the result of function*/
  def mapExclusiveMaximum(f: Boolean => Boolean) : JSONSchemaProps = copy(exclusiveMaximum = exclusiveMaximum.map(f))

  /** Returns a new data with format set to new value */
  def withFormat(value: String) : JSONSchemaProps = copy(format = Some(value))
  /** if format has a value, transforms to the result of function*/
  def mapFormat(f: String => String) : JSONSchemaProps = copy(format = format.map(f))

  /** Returns a new data with ref set to new value */
  def withRef(value: String) : JSONSchemaProps = copy(ref = Some(value))
  /** if ref has a value, transforms to the result of function*/
  def mapRef(f: String => String) : JSONSchemaProps = copy(ref = ref.map(f))

  /** Returns a new data with nullable set to new value */
  def withNullable(value: Boolean) : JSONSchemaProps = copy(nullable = Some(value))
  /** if nullable has a value, transforms to the result of function*/
  def mapNullable(f: Boolean => Boolean) : JSONSchemaProps = copy(nullable = nullable.map(f))

  /** Returns a new data with `x-kubernetes-map-type` set to new value */
  def withXKubernetesMapType(value: String) : JSONSchemaProps = copy(`x-kubernetes-map-type` = Some(value))
  /** if `x-kubernetes-map-type` has a value, transforms to the result of function*/
  def mapXKubernetesMapType(f: String => String) : JSONSchemaProps = copy(`x-kubernetes-map-type` = `x-kubernetes-map-type`.map(f))

  /** Returns a new data with pattern set to new value */
  def withPattern(value: String) : JSONSchemaProps = copy(pattern = Some(value))
  /** if pattern has a value, transforms to the result of function*/
  def mapPattern(f: String => String) : JSONSchemaProps = copy(pattern = pattern.map(f))

  /** Returns a new data with description set to new value */
  def withDescription(value: String) : JSONSchemaProps = copy(description = Some(value))
  /** if description has a value, transforms to the result of function*/
  def mapDescription(f: String => String) : JSONSchemaProps = copy(description = description.map(f))

  /** Returns a new data with anyOf set to new value */
  def withAnyOf(value: Seq[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps]) : JSONSchemaProps = copy(anyOf = Some(value))
  /** Appends new values to anyOf */
  def addAnyOf(newValues: io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps*) : JSONSchemaProps = copy(anyOf = Some(anyOf.fold(newValues)(_ ++ newValues)))
  /** if anyOf has a value, transforms to the result of function*/
  def mapAnyOf(f: Seq[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps] => Seq[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps]) : JSONSchemaProps = copy(anyOf = anyOf.map(f))

  /** Returns a new data with `x-kubernetes-list-type` set to new value */
  def withXKubernetesListType(value: String) : JSONSchemaProps = copy(`x-kubernetes-list-type` = Some(value))
  /** if `x-kubernetes-list-type` has a value, transforms to the result of function*/
  def mapXKubernetesListType(f: String => String) : JSONSchemaProps = copy(`x-kubernetes-list-type` = `x-kubernetes-list-type`.map(f))

  /** Returns a new data with patternProperties set to new value */
  def withPatternProperties(value: Map[String, io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps]) : JSONSchemaProps = copy(patternProperties = Some(value))
  /** Adds new values to patternProperties */
  def addPatternProperties(newValues: (String, io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps)*) : JSONSchemaProps = copy(patternProperties = Some(patternProperties.fold(newValues.toMap)(_ ++ newValues)))
  /** if patternProperties has a value, transforms to the result of function*/
  def mapPatternProperties(f: Map[String, io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps] => Map[String, io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps]) : JSONSchemaProps = copy(patternProperties = patternProperties.map(f))

  /** Returns a new data with items set to new value */
  def withItems(value: io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaPropsOrArray) : JSONSchemaProps = copy(items = Some(value))
  /** if items has a value, transforms to the result of function*/
  def mapItems(f: io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaPropsOrArray => io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaPropsOrArray) : JSONSchemaProps = copy(items = items.map(f))

  /** Returns a new data with additionalItems set to new value */
  def withAdditionalItems(value: io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaPropsOrBool) : JSONSchemaProps = copy(additionalItems = Some(value))
  /** if additionalItems has a value, transforms to the result of function*/
  def mapAdditionalItems(f: io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaPropsOrBool => io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaPropsOrBool) : JSONSchemaProps = copy(additionalItems = additionalItems.map(f))

  /** Returns a new data with maxProperties set to new value */
  def withMaxProperties(value: Int) : JSONSchemaProps = copy(maxProperties = Some(value))
  /** if maxProperties has a value, transforms to the result of function*/
  def mapMaxProperties(f: Int => Int) : JSONSchemaProps = copy(maxProperties = maxProperties.map(f))

  /** Returns a new data with maxItems set to new value */
  def withMaxItems(value: Int) : JSONSchemaProps = copy(maxItems = Some(value))
  /** if maxItems has a value, transforms to the result of function*/
  def mapMaxItems(f: Int => Int) : JSONSchemaProps = copy(maxItems = maxItems.map(f))

  /** Returns a new data with `x-kubernetes-int-or-string` set to new value */
  def withXKubernetesIntOrString(value: Boolean) : JSONSchemaProps = copy(`x-kubernetes-int-or-string` = Some(value))
  /** if `x-kubernetes-int-or-string` has a value, transforms to the result of function*/
  def mapXKubernetesIntOrString(f: Boolean => Boolean) : JSONSchemaProps = copy(`x-kubernetes-int-or-string` = `x-kubernetes-int-or-string`.map(f))

  /** Returns a new data with `x-kubernetes-embedded-resource` set to new value */
  def withXKubernetesEmbeddedResource(value: Boolean) : JSONSchemaProps = copy(`x-kubernetes-embedded-resource` = Some(value))
  /** if `x-kubernetes-embedded-resource` has a value, transforms to the result of function*/
  def mapXKubernetesEmbeddedResource(f: Boolean => Boolean) : JSONSchemaProps = copy(`x-kubernetes-embedded-resource` = `x-kubernetes-embedded-resource`.map(f))

  /** Returns a new data with maximum set to new value */
  def withMaximum(value: Double) : JSONSchemaProps = copy(maximum = Some(value))
  /** if maximum has a value, transforms to the result of function*/
  def mapMaximum(f: Double => Double) : JSONSchemaProps = copy(maximum = maximum.map(f))

  /** Returns a new data with multipleOf set to new value */
  def withMultipleOf(value: Double) : JSONSchemaProps = copy(multipleOf = Some(value))
  /** if multipleOf has a value, transforms to the result of function*/
  def mapMultipleOf(f: Double => Double) : JSONSchemaProps = copy(multipleOf = multipleOf.map(f))

  /** Returns a new data with id set to new value */
  def withId(value: String) : JSONSchemaProps = copy(id = Some(value))
  /** if id has a value, transforms to the result of function*/
  def mapId(f: String => String) : JSONSchemaProps = copy(id = id.map(f))

  /** Returns a new data with properties set to new value */
  def withProperties(value: Map[String, io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps]) : JSONSchemaProps = copy(properties = Some(value))
  /** Adds new values to properties */
  def addProperties(newValues: (String, io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps)*) : JSONSchemaProps = copy(properties = Some(properties.fold(newValues.toMap)(_ ++ newValues)))
  /** if properties has a value, transforms to the result of function*/
  def mapProperties(f: Map[String, io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps] => Map[String, io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps]) : JSONSchemaProps = copy(properties = properties.map(f))

  /** Returns a new data with exclusiveMinimum set to new value */
  def withExclusiveMinimum(value: Boolean) : JSONSchemaProps = copy(exclusiveMinimum = Some(value))
  /** if exclusiveMinimum has a value, transforms to the result of function*/
  def mapExclusiveMinimum(f: Boolean => Boolean) : JSONSchemaProps = copy(exclusiveMinimum = exclusiveMinimum.map(f))

  /** Returns a new data with `x-kubernetes-validations` set to new value */
  def withXKubernetesValidations(value: Seq[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.ValidationRule]) : JSONSchemaProps = copy(`x-kubernetes-validations` = Some(value))
  /** Appends new values to `x-kubernetes-validations` */
  def addXKubernetesValidations(newValues: io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.ValidationRule*) : JSONSchemaProps = copy(`x-kubernetes-validations` = Some(`x-kubernetes-validations`.fold(newValues)(_ ++ newValues)))
  /** if `x-kubernetes-validations` has a value, transforms to the result of function*/
  def mapXKubernetesValidations(f: Seq[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.ValidationRule] => Seq[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.ValidationRule]) : JSONSchemaProps = copy(`x-kubernetes-validations` = `x-kubernetes-validations`.map(f))

  /** Returns a new data with `enum` set to new value */
  def withEnum(value: Seq[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSON]) : JSONSchemaProps = copy(`enum` = Some(value))
  /** Appends new values to `enum` */
  def addEnum(newValues: io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSON*) : JSONSchemaProps = copy(`enum` = Some(`enum`.fold(newValues)(_ ++ newValues)))
  /** if `enum` has a value, transforms to the result of function*/
  def mapEnum(f: Seq[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSON] => Seq[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSON]) : JSONSchemaProps = copy(`enum` = `enum`.map(f))

  /** Returns a new data with `x-kubernetes-preserve-unknown-fields` set to new value */
  def withXKubernetesPreserveUnknownFields(value: Boolean) : JSONSchemaProps = copy(`x-kubernetes-preserve-unknown-fields` = Some(value))
  /** if `x-kubernetes-preserve-unknown-fields` has a value, transforms to the result of function*/
  def mapXKubernetesPreserveUnknownFields(f: Boolean => Boolean) : JSONSchemaProps = copy(`x-kubernetes-preserve-unknown-fields` = `x-kubernetes-preserve-unknown-fields`.map(f))

  /** Returns a new data with additionalProperties set to new value */
  def withAdditionalProperties(value: io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaPropsOrBool) : JSONSchemaProps = copy(additionalProperties = Some(value))
  /** if additionalProperties has a value, transforms to the result of function*/
  def mapAdditionalProperties(f: io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaPropsOrBool => io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaPropsOrBool) : JSONSchemaProps = copy(additionalProperties = additionalProperties.map(f))

  /** Returns a new data with default set to new value */
  def withDefault(value: io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSON) : JSONSchemaProps = copy(default = Some(value))
  /** if default has a value, transforms to the result of function*/
  def mapDefault(f: io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSON => io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSON) : JSONSchemaProps = copy(default = default.map(f))

  /** Returns a new data with minItems set to new value */
  def withMinItems(value: Int) : JSONSchemaProps = copy(minItems = Some(value))
  /** if minItems has a value, transforms to the result of function*/
  def mapMinItems(f: Int => Int) : JSONSchemaProps = copy(minItems = minItems.map(f))

  /** Returns a new data with not set to new value */
  def withNot(value: io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps) : JSONSchemaProps = copy(not = Some(value))
  /** if not has a value, transforms to the result of function*/
  def mapNot(f: io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps => io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps) : JSONSchemaProps = copy(not = not.map(f))

  /** Returns a new data with definitions set to new value */
  def withDefinitions(value: Map[String, io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps]) : JSONSchemaProps = copy(definitions = Some(value))
  /** Adds new values to definitions */
  def addDefinitions(newValues: (String, io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps)*) : JSONSchemaProps = copy(definitions = Some(definitions.fold(newValues.toMap)(_ ++ newValues)))
  /** if definitions has a value, transforms to the result of function*/
  def mapDefinitions(f: Map[String, io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps] => Map[String, io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps]) : JSONSchemaProps = copy(definitions = definitions.map(f))

  /** Returns a new data with minLength set to new value */
  def withMinLength(value: Int) : JSONSchemaProps = copy(minLength = Some(value))
  /** if minLength has a value, transforms to the result of function*/
  def mapMinLength(f: Int => Int) : JSONSchemaProps = copy(minLength = minLength.map(f))

  /** Returns a new data with `x-kubernetes-list-map-keys` set to new value */
  def withXKubernetesListMapKeys(value: Seq[String]) : JSONSchemaProps = copy(`x-kubernetes-list-map-keys` = Some(value))
  /** Appends new values to `x-kubernetes-list-map-keys` */
  def addXKubernetesListMapKeys(newValues: String*) : JSONSchemaProps = copy(`x-kubernetes-list-map-keys` = Some(`x-kubernetes-list-map-keys`.fold(newValues)(_ ++ newValues)))
  /** if `x-kubernetes-list-map-keys` has a value, transforms to the result of function*/
  def mapXKubernetesListMapKeys(f: Seq[String] => Seq[String]) : JSONSchemaProps = copy(`x-kubernetes-list-map-keys` = `x-kubernetes-list-map-keys`.map(f))

  /** Returns a new data with title set to new value */
  def withTitle(value: String) : JSONSchemaProps = copy(title = Some(value))
  /** if title has a value, transforms to the result of function*/
  def mapTitle(f: String => String) : JSONSchemaProps = copy(title = title.map(f))

  /** Returns a new data with minimum set to new value */
  def withMinimum(value: Double) : JSONSchemaProps = copy(minimum = Some(value))
  /** if minimum has a value, transforms to the result of function*/
  def mapMinimum(f: Double => Double) : JSONSchemaProps = copy(minimum = minimum.map(f))

  /** Returns a new data with `type` set to new value */
  def withType(value: String) : JSONSchemaProps = copy(`type` = Some(value))
  /** if `type` has a value, transforms to the result of function*/
  def mapType(f: String => String) : JSONSchemaProps = copy(`type` = `type`.map(f))

  /** Returns a new data with required set to new value */
  def withRequired(value: Seq[String]) : JSONSchemaProps = copy(required = Some(value))
  /** Appends new values to required */
  def addRequired(newValues: String*) : JSONSchemaProps = copy(required = Some(required.fold(newValues)(_ ++ newValues)))
  /** if required has a value, transforms to the result of function*/
  def mapRequired(f: Seq[String] => Seq[String]) : JSONSchemaProps = copy(required = required.map(f))

  /** Returns a new data with example set to new value */
  def withExample(value: io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSON) : JSONSchemaProps = copy(example = Some(value))
  /** if example has a value, transforms to the result of function*/
  def mapExample(f: io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSON => io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSON) : JSONSchemaProps = copy(example = example.map(f))

  /** Returns a new data with schema set to new value */
  def withSchema(value: String) : JSONSchemaProps = copy(schema = Some(value))
  /** if schema has a value, transforms to the result of function*/
  def mapSchema(f: String => String) : JSONSchemaProps = copy(schema = schema.map(f))

  /** Returns a new data with oneOf set to new value */
  def withOneOf(value: Seq[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps]) : JSONSchemaProps = copy(oneOf = Some(value))
  /** Appends new values to oneOf */
  def addOneOf(newValues: io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps*) : JSONSchemaProps = copy(oneOf = Some(oneOf.fold(newValues)(_ ++ newValues)))
  /** if oneOf has a value, transforms to the result of function*/
  def mapOneOf(f: Seq[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps] => Seq[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps]) : JSONSchemaProps = copy(oneOf = oneOf.map(f))

  /** Returns a new data with uniqueItems set to new value */
  def withUniqueItems(value: Boolean) : JSONSchemaProps = copy(uniqueItems = Some(value))
  /** if uniqueItems has a value, transforms to the result of function*/
  def mapUniqueItems(f: Boolean => Boolean) : JSONSchemaProps = copy(uniqueItems = uniqueItems.map(f))

  /** Returns a new data with minProperties set to new value */
  def withMinProperties(value: Int) : JSONSchemaProps = copy(minProperties = Some(value))
  /** if minProperties has a value, transforms to the result of function*/
  def mapMinProperties(f: Int => Int) : JSONSchemaProps = copy(minProperties = minProperties.map(f))

  /** Returns a new data with dependencies set to new value */
  def withDependencies(value: Map[String, io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaPropsOrStringArray]) : JSONSchemaProps = copy(dependencies = Some(value))
  /** Adds new values to dependencies */
  def addDependencies(newValues: (String, io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaPropsOrStringArray)*) : JSONSchemaProps = copy(dependencies = Some(dependencies.fold(newValues.toMap)(_ ++ newValues)))
  /** if dependencies has a value, transforms to the result of function*/
  def mapDependencies(f: Map[String, io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaPropsOrStringArray] => Map[String, io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaPropsOrStringArray]) : JSONSchemaProps = copy(dependencies = dependencies.map(f))

  /** Returns a new data with externalDocs set to new value */
  def withExternalDocs(value: io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.ExternalDocumentation) : JSONSchemaProps = copy(externalDocs = Some(value))
  /** if externalDocs has a value, transforms to the result of function*/
  def mapExternalDocs(f: io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.ExternalDocumentation => io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.ExternalDocumentation) : JSONSchemaProps = copy(externalDocs = externalDocs.map(f))

  /** Returns a new data with maxLength set to new value */
  def withMaxLength(value: Int) : JSONSchemaProps = copy(maxLength = Some(value))
  /** if maxLength has a value, transforms to the result of function*/
  def mapMaxLength(f: Int => Int) : JSONSchemaProps = copy(maxLength = maxLength.map(f))

  /** Returns a new data with allOf set to new value */
  def withAllOf(value: Seq[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps]) : JSONSchemaProps = copy(allOf = Some(value))
  /** Appends new values to allOf */
  def addAllOf(newValues: io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps*) : JSONSchemaProps = copy(allOf = Some(allOf.fold(newValues)(_ ++ newValues)))
  /** if allOf has a value, transforms to the result of function*/
  def mapAllOf(f: Seq[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps] => Seq[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps]) : JSONSchemaProps = copy(allOf = allOf.map(f))
}

