package io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1


/** CustomResourceValidation is a list of validation methods for CustomResources. */
final case class CustomResourceValidation(
  openAPIV3Schema : Option[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps] = None
) {

  /** Returns a new data with openAPIV3Schema set to new value */
  def withOpenAPIV3Schema(value: io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps) : CustomResourceValidation = copy(openAPIV3Schema = Some(value))
  /** if openAPIV3Schema has a value, transforms to the result of function*/
  def mapOpenAPIV3Schema(f: io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps => io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps) : CustomResourceValidation = copy(openAPIV3Schema = openAPIV3Schema.map(f))
}

