package io.k8s.api.storage.v1


/** VolumeAttachmentSpec is the specification of a VolumeAttachment request. */
final case class VolumeAttachmentSpec(
  attacher : String,
  nodeName : String,
  source : io.k8s.api.storage.v1.VolumeAttachmentSource
) {

  /** Returns a new data with attacher set to new value */
  def withAttacher(value: String) : VolumeAttachmentSpec = copy(attacher = value)
  /** transforms attacher to result of function */
  def mapAttacher(f: String => String) : VolumeAttachmentSpec = copy(attacher = f(attacher))

  /** Returns a new data with nodeName set to new value */
  def withNodeName(value: String) : VolumeAttachmentSpec = copy(nodeName = value)
  /** transforms nodeName to result of function */
  def mapNodeName(f: String => String) : VolumeAttachmentSpec = copy(nodeName = f(nodeName))

  /** Returns a new data with source set to new value */
  def withSource(value: io.k8s.api.storage.v1.VolumeAttachmentSource) : VolumeAttachmentSpec = copy(source = value)
  /** transforms source to result of function */
  def mapSource(f: io.k8s.api.storage.v1.VolumeAttachmentSource => io.k8s.api.storage.v1.VolumeAttachmentSource) : VolumeAttachmentSpec = copy(source = f(source))
}

