package io.k8s.api.storage.v1


/** TokenRequest contains parameters of a service account token. */
final case class TokenRequest(
  audience : String,
  expirationSeconds : Option[Int] = None
) {

  /** Returns a new data with audience set to new value */
  def withAudience(value: String) : TokenRequest = copy(audience = value)
  /** transforms audience to result of function */
  def mapAudience(f: String => String) : TokenRequest = copy(audience = f(audience))

  /** Returns a new data with expirationSeconds set to new value */
  def withExpirationSeconds(value: Int) : TokenRequest = copy(expirationSeconds = Some(value))
  /** if expirationSeconds has a value, transforms to the result of function*/
  def mapExpirationSeconds(f: Int => Int) : TokenRequest = copy(expirationSeconds = expirationSeconds.map(f))
}

