package io.k8s.api.node.v1

import dev.hnaderi.k8s._

/** RuntimeClass defines a class of container runtime supported in the cluster. The RuntimeClass is used to determine which container runtime is used to run all containers in a pod. RuntimeClasses are manually defined by a user or cluster provisioner, and referenced in the PodSpec. The Kubelet is responsible for resolving the RuntimeClassName reference before running the pod.  For more details, see https://kubernetes.io/docs/concepts/containers/runtime-class/ */
final case class RuntimeClass(
  handler : String,
  scheduling : Option[io.k8s.api.node.v1.Scheduling] = None,
  overhead : Option[io.k8s.api.node.v1.Overhead] = None,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("node.k8s.io", "RuntimeClass", "v1")


  /** Returns a new data with handler set to new value */
  def withHandler(value: String) : RuntimeClass = copy(handler = value)
  /** transforms handler to result of function */
  def mapHandler(f: String => String) : RuntimeClass = copy(handler = f(handler))

  /** Returns a new data with scheduling set to new value */
  def withScheduling(value: io.k8s.api.node.v1.Scheduling) : RuntimeClass = copy(scheduling = Some(value))
  /** if scheduling has a value, transforms to the result of function*/
  def mapScheduling(f: io.k8s.api.node.v1.Scheduling => io.k8s.api.node.v1.Scheduling) : RuntimeClass = copy(scheduling = scheduling.map(f))

  /** Returns a new data with overhead set to new value */
  def withOverhead(value: io.k8s.api.node.v1.Overhead) : RuntimeClass = copy(overhead = Some(value))
  /** if overhead has a value, transforms to the result of function*/
  def mapOverhead(f: io.k8s.api.node.v1.Overhead => io.k8s.api.node.v1.Overhead) : RuntimeClass = copy(overhead = overhead.map(f))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : RuntimeClass = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : RuntimeClass = copy(metadata = metadata.map(f))
}

